IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Clientes_Deuda_Resumen') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Clientes_Deuda_Resumen
END
GO

CREATE PROCEDURE [dbo].[CPJ_Clientes_Deuda_Resumen]	@pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

/*Parametros*/
DECLARE @pFechaDesde			DATETIME,
		@pFechaHasta			DATETIME,
		@pId_Unid_Negocio       VARCHAR(10),
		@pFiltrar_con_saldo     TINYINT,
		@pClientes_activos      TINYINT,
		@pId_Cliente            INT,
		@pId_Cliente_Tit		INT,
		@pFiltroFecha           TINYINT,
		@pEquate                SMALLINT,
		@pUsuario               INT,
		@pId_Familia            INT,
		@pId_Producto           VARCHAR(14),
		@pFormato			    CHAR(10),
		-- C=Total x Cliente 
		-- F=Total por Factura 
		-- P=Total por Producto X-Comparativo 
		-- TP-Total por producto
		-- TF-Total por familia
		-- TPM-Total por producto/mes 
		-- TFM-Total por RUBRO/mes 

		@pOrden                 CHAR(10)
		-- CP = CLIENTE / PRODUCTO

/*Fin de Parametros*/

	
		/*Seteo Parametros*/
		SET @pId_Unid_Negocio			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Unid_Negocio')),'')
		SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
		SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())
		SET @pFiltrar_con_saldo			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Filtrar_con_saldo')),0)
		SET @pClientes_activos			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Clientes_activos')),0)
		SET @pFormato					= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Formato')),'')
		SET @pId_Cliente				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente')),0)
		SET @pFiltroFecha		    	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltroFecha')),0)
		SET @pEquate		        	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Equate')),0)
		SET @pUsuario		        	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Usuario')),0)
		SET @pEquate					= 400
		SET @pOrden				     	= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Orden')),'')
		SET @pId_Familia				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Familia')),0)
		SET @pId_Producto				= ISNULL(CONVERT(CHAR(14), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Producto')),'')

		/*Fin Seteo Parametros*/

		/*Declaro Variables Locales*/
		DECLARE  @Id_Producto					VARCHAR(14)
				,@Id_Proveedor					INT
				,@Razon_Social					VARCHAR(100)
				,@Cuit							VARCHAR(13)
				,@Id_Iva						CHAR(3)
				,@Id_Alias_Cta_Cont				INT
				,@Id_Cta_Contable_H				INT
				,@Porc_Comision_Prov			DECIMAL(7,2) 
				,@Importe						DECIMAL(12,2) 
				,@IMPORTE_CREDITO				DECIMAL(12,2) 
				,@ID_TIPO_CBTE					CHAR(4) 
				,@FECHA							DATETIME
				,@Imp_prod_siva					DECIMAL(12,2) 
				,@TRANS							INT
				,@Id_Cliente_Externo			VARCHAR(14)
				,@Id_Cta_Banco					INT
				,@Id_Cliente					INT
				,@EXISTE_TAG					INT
				,@Cli_Ref_CtaCte_Agrup			TINYINT
			    ,@DEUDA_TOTAL  Decimal(14,2) 

        IF @pFormato = '' and (@pId_Familia <> 0 or @pId_Producto <> '')
		   set @pFormato = 'C'


		DECLARE @Sql		    VARCHAR(MAX)
		DECLARE @SqlSaldo	    VARCHAR(MAX)
		DECLARE @SqlSelect		VARCHAR(MAX)
		DECLARE @SqlSelectRec	VARCHAR(MAX)
		DECLARE @SqlFrom	    VARCHAR(MAX)
		DECLARE @SqlFromRec	    VARCHAR(MAX)
		DECLARE @SqlWhere		VARCHAR(MAX)
		DECLARE @SqlWhereFac	VARCHAR(MAX)
		DECLARE @SqlWhereRec	VARCHAR(MAX)
		DECLARE @SqlOrden   	VARCHAR(MAX)
		DECLARE @sqlgroup       VARCHAR(MAX)
		DECLARE @SqlHaving      VARCHAR(MAX)

		/*Fin Variables Locales*/

		SET @Sql	    = ''
		SET @SqlSaldo	= ''
		SET @SqlSelect	= ''
		SET @SqlSelectRec	= ''
		SET @SqlFrom	= ''
		SET @SqlFromRec	= ''
		SET @SqlWhere	= ''
		SET @SqlWhereFac	= ''
		SET @SqlWhereRec	= ''
		SET @SqlOrden	    = ''
		SET @sqlgroup       = ''
		SET @SqlHaving      = ''

		SET @FECHA		= (SELECT CAST(GETDATE() AS DATE))
		SET @EXISTE_TAG = 0

		SELECT ID_UNID_NEGOCIO 
			INTO #UN FROM Empresas_Unid_Negocios

		IF(CAST(@pId_Unid_Negocio AS INT)) <> 0
			DELETE #UN WHERE ID_UNID_NEGOCIO <> @pId_Unid_Negocio


		CREATE TABLE #ACTIVO (ACTIVO TINYINT)
			INSERT INTO #ACTIVO (ACTIVO) VALUES (1)

		IF(@pClientes_activos) <> 1
			INSERT INTO #ACTIVO (ACTIVO) VALUES (0)

        SET @Cli_Ref_CtaCte_Agrup = CONVERT(TINYINT,dbo.CF_xParam('Cli_Ref_CtaCte_Agrup'))
		SELECT @pId_Cliente_Tit = Id_Cliente_Ref FROM Clientes WHERE Id_Cliente = @pId_Cliente
		IF ISNULL(@pId_Cliente_Tit,0) = 0 
			SET @pId_Cliente_Tit = @pId_Cliente

		/************************************************ SQL SELECT ************************************************/
		CREATE TABLE #Result (
			Id_Cliente			INT
			,Razon_Social		VARCHAR(100)
			,Id_Trans			INT
			,Id_Tipo_Cbte		CHAR(4)
			,Fecha				DATETIME
			,Fecha_Venc			DATETIME
			,Cbte_Descrip		VARCHAR(100)
			,Nro_Cuota			INT
			,Id_Producto		VARCHAR(14)
			,Producto			VARCHAR(150)
			,Saldo				DECIMAL(16,2)
			,Id_Cliente_Ref		INT 
			,Id_Familia         INT
			,Familia            VARCHAR(150) 
			,Deuda_total        DECIMAL(16,2)
			,Cotizacion			DECIMAL(12,5)
			)

		IF @pFormato IN ('','C','X')
			SET @SqlSelect = 'INSERT INTO #Result (Id_Cliente,Razon_Social,Id_Cliente_Ref,Saldo,Cotizacion) 
				SELECT C.Id_Cliente, C.Razon_Social,C.Id_Cliente_Ref, (CC.Saldo  * F.Cotizacion  ) AS Saldo,F.Cotizacion'
        
		IF @pFormato IN ('F')
			SET @SqlSelect = 'INSERT INTO #Result (Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Nro_Cuota,Saldo,Cotizacion) 
				SELECT C.Id_Cliente, C.Razon_Social,C.Id_Cliente_Ref,F.Id_Trans,F.Id_Tipo_Cbte,F.Fecha,F.Fecha_Venc,CC.Nro_Cuota, (CC.Saldo  * F.Cotizacion) AS Saldo, F.Cotizacion'

		IF @pFormato IN ('P','TP','TPM','TF','PC','PCD','TFM')
		BEGIN
			SET @SqlSelect = 'INSERT INTO #Result (Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans
								,Id_Tipo_Cbte,Fecha,Fecha_Venc,Cbte_Descrip,Nro_Cuota,I.Id_Producto
								,Producto,Saldo,Id_Familia,Familia,Cotizacion) 
				SELECT C.Id_Cliente, C.Razon_Social,C.Id_Cliente_Ref,F.Id_Trans
								,F.Id_Tipo_Cbte,I.Fecha_QA,I.Fecha_Venc,CC.Descripcion,CC.Nro_Cuota,I.Id_Producto
								,P.Descripcion_Detallada,I.Imp_Final * F.Cotizacion * (CC.Saldo / CC.Importe) * (CC.Importe/F.Imp_Total) AS Saldo,P.Id_Familia,FA.Descripcion as Familia, F.Cotizacion'

			SET @SqlSelectRec = 'INSERT INTO #Result (Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Cbte_Descrip,Nro_Cuota,Saldo,Cotizacion) 
				SELECT C.Id_Cliente, C.Razon_Social,C.Id_Cliente_Ref,F.Id_Trans,F.Id_Tipo_Cbte,F.Fecha,F.Fecha_Venc,CC.Descripcion,CC.Nro_Cuota, (CC.Saldo  * F.Cotizacion) AS Saldo,F.Cotizacion'
			
		END
--		PRINT 'SEL1 '+ @SqlSelect
		/************************************************ SQL FROM ************************************************/

		SET @SqlFrom = ' FROM Clientes_Ctacte CC
								JOIN Cbtes F ON CC.Id_Trans = F.Id_Trans
								JOIN Cbtes_Tipos TF ON F.Id_Tipo_Cbte = TF.Id_Tipo_Cbte
								JOIN Clientes C ON CC.Id_Cliente = C.Id_Cliente
								LEFT JOIN Clientes_Tipos TC ON C.Id_Tipo_Cli = TC.Id_Tipo_Cli
								JOIN #UN U ON TF.Id_Unid_Negocio = U.Id_Unid_Negocio
								JOIN #ACTIVO A ON C.Activo = A.Activo'

		IF @pFormato IN ('P','TP','TPM','TF','PC','PCD','TFM','C')
		BEGIN
			SET @SqlFromRec = @SqlFrom
			SET @SqlFrom += '	LEFT JOIN Cbtes_Items I ON F.Id_Trans = I.Id_Trans
								LEFT JOIN Productos P ON I.Id_Producto = P.Id_Producto 
                                LEFT JOIN Prod_Familias FA ON P.Id_Familia = FA.Id_Familia '
		END

		/************************************************ SQL WHERE ************************************************/

		SET @SqlWhere =	  ' WHERE CC.Id_Estado_Cbte IN (1,4)
									AND F.Id_Cliente <> 0
									AND F.Id_Estado_Cbte IN (1,4)
									AND TF.Letra <> ''L''
									AND CC.Saldo <> 0  
									AND ABS(CC.SALDO) >= 1
									AND CC.Saldo is not null
									AND F.Imp_Total <> 0 
									AND CC.Importe <> 0 '

        IF @pFormato IN ('','C','F')
			BEGIN 
				SET @SqlWhereFac +=	  ' AND F.ID_COND_PAGO <> 1 AND (TF.Compromete_Factura IN (1,-1) OR TF.Compromete_Recibos IN (1,-1))'
				SET @SqlWhereRec =	  ' AND TF.Compromete_Recibos IN (1,-1) ' 
			END
        ELSE
			BEGIN
				SET @SqlWhereFac =	  ' AND F.ID_COND_PAGO <> 1 AND TF.Compromete_Factura IN (1,-1) '
				SET @SqlWhereRec =	  ' AND TF.Compromete_Recibos IN (1,-1) '   --los recibos van a parte
			END

		IF @pId_Familia <> 0 
			 SET @SqlWhereFac +=	  ' AND P.Id_Familia = ' + CONVERT(VARCHAR(8),@pId_Familia) 
			 
		IF @pId_Producto <> '' 
		   BEGIN
			 SET @SqlWhereRec =	  '' 
			 SET @SqlWhereFac +=  ' AND P.Id_Producto = ''' + CONVERT(VARCHAR(14),@pId_Producto) +''''
           END
		IF(@pFiltroFecha) = 0
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND F.Fecha < ''' + CONVERT(VARCHAR(8),@pFechaHasta+1,112) +'''' 
		ELSE
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CC.Fecha_Venc < ''' + CONVERT(VARCHAR(8),@pFechaHasta+1,112) +'''' 

		IF(@pId_Cliente) <> 0
		BEGIN
		    IF @Cli_Ref_CtaCte_Agrup <> 0
				SET @SqlWhere += ' AND ( CC.Id_Cliente = ' + CONVERT(VARCHAR(8),@pId_Cliente_Tit) + ' OR C.Id_Cliente_Ref = ' + CONVERT(VARCHAR(8),@pId_Cliente_Tit) +')'
            ELSE
				SET @SqlWhere += ' AND CC.Id_Cliente = ' + CONVERT(VARCHAR(8),@pId_Cliente_Tit) 

        END

		/************************************************ GROUP BY ************************************************/
		--SET @SqlGroup = ' GROUP BY C.Id_Cliente, C.Razon_Social, Descripcion_Detallada '


		SET @Sql = @SqlSelect + ' ' + ' '+ @SqlFrom + ' ' + @SqlWhere +' '+ @SqlWhereFac 

		/**********************************************************************************************************/

  		PRINT '1  '+ @Sql
		EXEC(@sql)

		/***********************************************************Formato Producto Cargo los recibos****************/
		IF @pFormato IN ('TP','TPM','PC')
		BEGIN
			SET @Sql = @SqlSelectRec + ' ' +' '+ @SqlFromRec + ' ' + @SqlWhere + @SqlWhereRec
			PRINT '2 '+ @Sql
			EXEC(@sql)
		END


		/**********************************************************************************************************/

		IF @Cli_Ref_CtaCte_Agrup <> 0
		BEGIN
			UPDATE #Result SET Id_Cliente_Ref = Id_Cliente WHERE Id_Cliente_Ref IS NULL
			UPDATE #Result SET Id_Cliente_Ref = Id_Cliente WHERE Id_Cliente_Ref = 0
			
			UPDATE #Result SET Id_Cliente = C.Id_Cliente, Razon_Social = C.Razon_Social 
					FROM #Result R JOIN Clientes C ON R.Id_Cliente_Ref = C.Id_Cliente 
					WHERE R.Id_Cliente_Ref <> R.Id_Cliente
		END
		/*
		update  #result set id_producto = 'ACUENTA',PRODUCTO = 'PAGOS A CUENTA',ID_FAMILIA = 99999, FAMILIA = 'PAGOS A CUENTA' 
				WHERE (ID_FAMILIA IS NULL OR ID_FAMILIA  = 0 OR FAMILIA  = 'NULL')

		update  #result set id_producto = 'ACUENTA',PRODUCTO = 'PAGOS A CUENTA',ID_FAMILIA = 99999, FAMILIA = 'PAGOS A CUENTA' 
				WHERE (ID_FAMILIA IS NULL OR ID_FAMILIA  = 0 OR FAMILIA  = 'NULL')

				*/
		update  #result set saldo = 0 WHERE saldo IS NULL  
        SET @DEUDA_TOTAL = (SELECT SUM(Saldo) FROM #result)
	    UPDATE #result SET Deuda_Total = @DEUDA_TOTAL --, Saldo = Saldo * Cotizacion   --duplica

		/**/
		IF @pFormato = 'X' -------------------- trae solo las diferencias
		BEGIN
			CREATE TABLE #Result_Det (
				Id_Cliente			INT
				,Razon_Social		VARCHAR(100)
				,Id_Trans			INT
				,Id_Tipo_Cbte		CHAR(4)
				,Fecha				DATETIME
				,Fecha_Venc			DATETIME
				,Cbte_Descrip		VARCHAR(100)
				,Nro_Cuota			INT
				,Id_Producto		VARCHAR(14)
				,Producto			VARCHAR(150)
				,Saldo				DECIMAL(16,2)
				,Id_Cliente_Ref		INT
			    ,Deuda_total        DECIMAL(16,2)
				)

			SET @pJsonRecibido = REPLACE(@pJsonRecibido,'"X"','"P"')
			INSERT INTO #Result_Det
				EXEC CPJ_Clientes_Deuda_Resumen @pJsonRecibido


            SELECT Id_Cliente,Razon_Social,Deuda_total,SUM(Saldo) AS Saldo INTO #Result_Det_Sum	FROM  #Result_Det	GROUP BY Id_Cliente,Razon_Social
			SELECT Id_Cliente,Razon_Social,Deuda_total,SUM(Saldo) AS Saldo INTO #Result_Sum		FROM  #Result		GROUP BY Id_Cliente,Razon_Social

			SELECT  R.Id_Cliente,R.Razon_Social,R.Saldo,R.Deuda_total FROM #Result_Sum R JOIN #Result_Det_Sum RD ON R.Id_Cliente = RD.Id_Cliente
				WHERE R.Saldo - RD.Saldo > 1 OR R.Saldo - RD.Saldo < -1

            DROP TABLE #Result_Det
			DROP TABLE #Result_Det_Sum
            DROP TABLE #Result_Sum 

		END
		ELSE
		BEGIN
				IF @pFormato IN ('','C')
				   BEGIN
				    set @sqlselect = ' SELECT  Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Cbte_Descrip,Nro_Cuota,Id_Producto,Producto,Deuda_Total,SUM(Saldo) AS Saldo	
							           FROM #Result '
					set @sqlwhere = ' '
                    set @sqlgroup  = ' GROUP BY Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Cbte_Descrip,Nro_Cuota,Id_Producto,Producto,Deuda_Total'
					set @SqlOrden  = ' ORDER BY Razon_Social'
                   END

				IF @pFormato IN ('P')
				   BEGIN
					set @sqlselect = 'SELECT Id_Producto,Producto,Deuda_Total,Sum(Saldo) as Saldo FROM #Result '
					set @sqlwhere = ' '
					set @sqlgroup = ' GROUP BY Id_Producto,Producto,Deuda_Total '
					set @SqlOrden  = ' ORDER BY Producto'
                   END

 				IF @pFormato IN ('PC')
				   BEGIN
					set @sqlselect = 'SELECT Id_Cliente,Razon_Social,Deuda_Total,Sum(Saldo) as Saldo FROM #Result '
				    set @sqlwhere = ' '
					set @sqlgroup = ' GROUP BY Id_Cliente,Razon_Social,Deuda_Total '

					If @pFiltrar_con_saldo = 1
					   set @sqlgroup = ' GROUP BY Id_Cliente,Razon_Social,Deuda_Total having Sum(Saldo) <> 0 '
					IF @pOrden = 'ID'
						SET @SqlOrden  = ' ORDER BY 4 DESC '
					ELSE IF @pOrden = 'IA'
						SET @SqlOrden  = ' ORDER BY 4 ASC'
					ELSE
						SET @SqlOrden  = ' ORDER BY Razon_Social'
                   END   

				IF @pFormato IN ('PCD')
				   BEGIN
				    set @sqlselect = ' SELECT  Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Cbte_Descrip,Nro_Cuota,Id_Producto,Producto,Deuda_Total,Saldo	
							           FROM #Result '
					set @sqlwhere = ' '
                    set @sqlgroup  = ' '
					set @SqlOrden  = ' ORDER BY Razon_Social,Producto,Fecha'
                   END

				   
 				IF @pFormato IN ( 'F')
				   BEGIN
					set @sqlselect = 'SELECT * FROM #Result '
					set @sqlwhere = ' '
					set @sqlgroup = ' '
					set @SqlOrden  = ' ORDER BY Razon_Social,Fecha_Venc'
                   END     
				   
				IF @pFormato = 'TP'
				   BEGIN
					set @sqlselect = 'SELECT  Id_Producto,Producto,Deuda_Total,SUM(Saldo) AS Saldo	
							          FROM #Result '
					set @sqlwhere = ' WHERE Id_Producto IS NOT NULL '

					set @sqlgroup =	' GROUP BY Producto,Id_Producto,Deuda_Total'
					set @SqlOrden = ' ORDER BY Saldo DESC '
                   END

				IF @pFormato = 'TF'
				   BEGIN
					set @sqlselect = 'SELECT  Id_Familia,Familia,Deuda_Total,SUM(Saldo) AS Saldo	
							          FROM #Result '
					set @sqlwhere = ' WHERE Id_Familia IS NOT NULL '

					set @sqlgroup =	' GROUP BY Familia,Id_Familia,Deuda_Total '
					set @SqlOrden = ' ORDER BY Saldo DESC '
                   END

				IF @pFormato = 'TPM'
				   BEGIN
					 set @sqlselect = ' SELECT  Id_Producto, Producto ,substring(convert(nvarchar(10),Fecha,112),1,6) +''01'' as Periodo,Deuda_Total,SUM(Saldo) AS Saldo
					            		FROM #Result '
				  	 set @sqlwhere = ' WHERE Id_Producto IS NOT NULL'
					 set @sqlgroup = ' GROUP BY substring(convert(nvarchar(10),Fecha,112),1,6)+''01'',Id_Producto, Producto,Deuda_Total '
					 set @SqlOrden = ' ORDER BY Producto,substring(convert(nvarchar(10),Fecha,112),1,6)+''01'''
                   END

				IF @pFormato = 'TFM'
				   BEGIN 

					 set @sqlselect = ' SELECT  Id_Familia, Familia ,substring(convert(nvarchar(10),Fecha,112),1,6) +''01'' as Periodo,Deuda_Total,SUM(Saldo) AS Saldo
					            		FROM #Result '
				  	 set @sqlwhere = ' WHERE Id_Familia IS NOT NULL'
					 set @sqlgroup = ' GROUP BY substring(convert(nvarchar(10),Fecha,112),1,6)+''01'',Id_Familia, Familia,Deuda_Total '
					 set @SqlOrden = ' ORDER BY Familia,substring(convert(nvarchar(10),Fecha,112),1,6)+''01'''
                   END
		END

		IF @pFiltrar_con_saldo = 1
			BEGIN
				  IF @pFormato IN ('','C')
				     set @SqlHaving = ' HAVING SUM(isnull(Saldo,0)) <> 0 '

			  	  IF @pFormato IN ( 'F','P','PC')
				     BEGIN
				       set @sqlwhere = ' WHERE SALDO <> 0 '
					   set @SqlHaving = ' '
					 END

				  IF @pFormato = 'TP'
                     set @SqlHaving = 'HAVING SUM(isnull(Saldo,0)) <> 0 '

				  IF @pFormato = 'TF'
                     set @SqlHaving = 'HAVING  SUM(isnull(Saldo,0)) <> 0 '

				  IF @pFormato = 'TPM' OR @pFormato = 'TFM'
				     set @SqlHaving = 'HAVING  SUM(isnull(Saldo,0)) <> 0 '
			END    

			--If @pOrden = 'CP'
			--   set @SqlOrden  = ' ORDER BY Razon_Social,Producto'

     
			SET @Sql = @SqlSelect + ' ' + @SqlWhere +' '+ @SqlGroup + ' '+ @SqlHaving  +' '+ @SqlOrden
			PRINT '3 '+ @Sql
			EXEC(@sql)
 

	--		SELECT sum(saldo) FROM #Result    --controlar uno con otro
					 					 
  			DROP TABLE #UN
			DROP TABLE #ACTIVO
			DROP TABLE #Result
		--END

		/*

		-- C=Total x Cliente 
		-- F=Total por Factura 
		-- P=Total por Producto X-Comparativo 
		-- TP-Total por producto
		-- TF-Total por familia
		-- TPM-Total por producto/mes 
		-- TFM-Total por FAMILIA/mes 

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"C"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Id_producto":""
									,"Usuario":"-1"}'


EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"PCD"
									,"FiltroFecha":"0"
									,"Id_producto":"V0017"
									,"Equate":"400"
									,"Usuario":"-1"}'

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"PC"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'


EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"P"
									,"Id_familia":"16"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'



EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20230808"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"TP"
									,"Id_Cliente":""
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"F"
									,"Id_Cliente":"0"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

									
EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20230831"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"TFM"
									,"Id_Cliente":"0"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20230810"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"1"
									,"Clientes_activos":"1"
									,"Formato":"pc"
									,"Id_Cliente":"0"
									,"Id_familia":""
									,"Id_Producto":"1028_04"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

 
EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"TPM"
									,"Id_Cliente":"0"
									,"FiltroFecha":"0"
									,"Id_Producto":"V0030"
									,"Equate":"400"
									,"Usuario":"-1"}'

SELECT * FROM  CBTES_ITEMS WHERE ID_TRANS = 116923

		*/
